(defmeth selection-overlay-proto :do-click (x y m1 m2)
  (when (< 15 y 32)
        (send (send self :graph) :line-type 'solid)
        (let* ((graph (send self :graph))
               (hilight (send graph :points-selected))
               (link-list (remove 'nil (send graph :links)))
               (color  (send self :which-color x y))
               (symbol (send self :which-symbol x y)))
          (when (and hilight (or color symbol))
                (when color (send graph :point-color hilight color))
                (when symbol (send graph :point-symbol hilight symbol))
                (when link-list
                      (dolist (plot link-list)
                              ;(send plot :use-color t)
                              (when color (send plot :point-color hilight color))
                              (when symbol (send plot :point-symbol hilight symbol))
                              (when (member vista-scatterplot-proto (send plot :precedence-list))    
                            (and   (send plot :has-slot 'add-linear)   (send plot :clear-curves)))
                              (send plot :redraw-content)
                              (send plot :points-selected hilight)))
                (send graph :redraw-content)
                (send graph :points-selected hilight))
          )))